<?php
/**
 * JHTMLHelper for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

/**
 * Utility class for creating HTML Calendar
 *
 * @static
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @since   1.5.5
 */
class JHtmlVisformscalendar
{
    /**
     * Displays a calendar control field
     *
     * @param   string $value The date value
     * @param   string $name The name of the text field
     * @param   string $id The id of the text field
     * @param   string $format The date format
     * @param   mixed $attribs Additional HTML attributes
     *
     * @return  string  HTML markup for a calendar field
     *
     * @since   1.5
     */
    public static function calendar($value, $name, $id, $format = '%Y-%m-%d', $attribs = null, $bt3layout = false, $label = null)
    {
        static $done;
        static $handlerloaded;

        if ($done === null)
        {
            $done = array();
        }

        $readonly = isset($attribs['readonly']) && $attribs['readonly'] == 'readonly';
        $disabled = isset($attribs['disabled']) && $attribs['disabled'] == 'disabled';

        if (is_array($attribs))
        {
            $attribs['class'] = isset($attribs['class']) ? $attribs['class'] : 'input-medium';
            $attribs['class'] = trim($attribs['class'] . ' hasTooltip');

            $attribs = JArrayHelper::toString($attribs);
        }
		
		
		
	    JHtml::_('bootstrap.tooltip');
		
        // Format value when not '0000-00-00 00:00:00', otherwise blank it as it would result in 1970-01-01.
        if ((int)$value)
        {
            $tz = date_default_timezone_get();
            date_default_timezone_set('UTC');
            $inputvalue = strftime($format, strtotime($value));
            date_default_timezone_set($tz);
        }
        else
        {
            $inputvalue = '';
        }
		$document = JFactory::getDocument();
		$jversion = new JVersion();
        // Load the calendar behavior
        JHtml::_('behavior.calendar');
		
        if (!$handlerloaded)
        {
			//Bugfix Joomla! 3.7 add css and javascript files which might be missing
			if (version_compare($jversion->getShortVersion(), '3.7.0', 'ge'))
			{
				$tag      = JFactory::getLanguage()->getTag();
				$document->addStyleSheet(JURI::root(true) . '/media/system/css/calendar-jos.css');
				JHtml::_('script', $tag . '/calendar-setup.js', array('version' => 'auto', 'relative' => true));
			}
            $document->addScriptDeclaration('function validateDateOnUpdate () {var input = jQuery(this.inputField); input.valid();}');
            $handlerloaded = true;
        }

        // Only display the triggers once for each control.
        if (!in_array($id, $done))
        {
            $document
                ->addScriptDeclaration(
                    'jQuery(document).ready(function($) {Calendar.setup({
			// Id of the input field
			inputField: "' . $id . '",
			// Format of the input field
			ifFormat: "' . $format . '",
			// Trigger for the calendar (button ID)
			button: "' . $id . '_img",
			// Alignment (defaults to "Bl")
			align: "Tl",
			singleClick: true,
			firstDay: ' . JFactory::getLanguage()->getFirstDay() . ',
            onUpdate : validateDateOnUpdate
			});});'
                );
            $done[] = $id;
        }

        // Hide button using inline styles for readonly/disabled fields
        $btn_style = ($readonly || $disabled) ? ' style="display:none;"' : '';
        if (!empty($bt3layout))
        {
            $div_class = (!$readonly) ? ' class="input-group"' : '';
        }
        else
        {
            $div_class = (!$readonly) ? ' class="input-append"' : '';
        }

        $html = '<div' . $div_class . '>';
        if (!empty($label))
        {
            $html .= $label;
        }
        $html .= '<input type="text" title="' . (0 !== (int)$value ? JHtml::_('date', $value, null, null) : '')
            . '" name="' . $name . '" id="' . $id . '" value="' . htmlspecialchars($inputvalue, ENT_COMPAT, 'UTF-8') . '" ' . $attribs . ' />';
        if (!empty($bt3layout))
        {
            $html .= '<span class="input-group-btn">'
                . '<button type="button" class="btn" id="' . $id . '_img"' . $btn_style . '><i class="visicon-calendar"></i></button>'
                . '</span>';
        }
        else
        {
            $html .= '<button type="button" class="btn" id="' . $id . '_img"' . $btn_style . '><i class="visicon-calendar"></i></button>';
        }
        $html .= '</div>';

        return $html;
    }
}

?>