<?php
/**
 * Visforms field pagebreak class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Visforms field Pagebreak
 *
 * @package        Joomla.Site
 * @subpackage    com_visforms
 * @since        1.6
 */
class VisformsFieldPagebreak extends VisformsField
{

    /**
     * Preprocess field. Set field properties according to field defition, query params, user inputs
     */

    protected function setField()
    {
        $this->extractDefaultValueParams();
        $this->setFieldDefaultValue();
        $this->setCustomJs();
        $this->setFieldsetCounter();
        $this->setMpDisplayType();
        if (empty($this->field->mpdisplaytype))
        {
            $this->addFormStep();
        }
        else if ($this->field->mpdisplaytype == 1)
        {
            $this->setAccordionCounter();
            $this->setAccordionId();
            JHtml::_('bootstrap.framework');
        }
        $this->setBackBtnText();
    }

    /**
     * The the default value of the field which is displayed in the form according field defition, query params, user inputs
     *
     * @return boolean
     */

    protected function setFieldDefaultValue()
    {
        //Nothing to do for Submit buttons
        return;
    }

    /**
     * Method to convert post values into a string that can be stored in db and attach it as property to the field object
     */
    protected function setDbValue()
    {
        return;
    }

    protected function setRedirectParam()
    {
        return;
    }

    protected function setBackBtnText()
    {
        $this->field->backbtntext = $this->form->backbtntext;
    }

    protected function setMpDisplayType()
    {
        $this->field->mpdisplaytype = isset($this->form->mpdisplaytype) ?  $this->form->mpdisplaytype : 0;
    }

    protected function setAccordionCounter()
    {
        if ((isset($this->form->accordioncounter)) && (is_numeric($this->form->accordioncounter)))
        {
            $this->form->accordioncounter++;
        }
        else
        {
            $this->form->accordioncounter = (int) 1;
        }
        $this->field->accordioncounter = $this->form->accordioncounter;
    }

    protected function setAccordionId()
    {
        $this->field->accordionid  = (!empty($this->form->context)) ? $this->form->context . 'accordion' : 'visform' . $this->form->id . 'accordion';
    }
}